﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Chunks
    {
        FileStream f;
        string className = "";
        List<byte> chunkList;
        List<byte> chunkCheckList;
        
        public Chunks(FileStream f, string className)
        {
            this.f = f;
            this.className = className;
        }
        public Chunks()
        {
        }
        
        // Returns whether chunk was used.
        public bool used(byte b)
        {
            if (chunkList == null)
                return false;
            
            return chunkList.Contains(b);
        }
        
        // Adds a chunk as used. Should be called externally if modifications to data add a chunk where it may have been absent before.
        public void add(byte b)
        {
            if (chunkList == null)
                chunkList = new List<byte>();
            
            if (!chunkList.Contains(b))
                chunkList.Add(b);
        }
        
        // Removes a chunk.
        public void remove(byte b)
        {
            if (chunkList == null)
                return;
            
            chunkList.Remove(b);
        }
        
        // Checks the next byte. If it matches, it returns true. Otherwise, it acts as if it were never read. Adds the byte to usedList if used.
        public bool next(byte b)
        {
            if (chunkCheckList == null)
                chunkCheckList = new List<byte>();
            chunkCheckList.Add(b);
            
            byte readB = M.readByte(f);
            if (readB >= 128)
            {
                f.Seek(-1, SeekOrigin.Current);
                readB = (byte)M.readMultibyte(f);
            }
            
            if (b == readB)
            {
                add(b);
                return true;
            }
            else
            {
                f.Seek(-M.countMultibyte(readB), SeekOrigin.Current);
                return false;
            }
        }
        
        // Checks if the byte code was used, according to the list; if so, writes it to the target and returns true.
        public bool wasNext(byte b)
        {
            if (used(b))
            {
                M.writeMultibyte(b);
                return true;
            }
            return false;
        }
        
        // Barebones static versions using external lists, for classes that are too numerous and thus cause too much overhead.
        public static bool next(FileStream f, byte b, List<int> usedList)
        {
            byte readB = M.readByte(f);
            if (readB >= 128)
            {
                f.Seek(-1, SeekOrigin.Current);
                readB = (byte)M.readMultibyte(f);
            }
            
            if (b == readB)
            {
                usedList.Add(b);
                return true;
            }
            else
            {
                f.Seek(-M.countMultibyte(readB), SeekOrigin.Current);
                return false;
            }
        }
        public static bool wasNext(byte b, List<int> usedList)
        {
            if (usedList.Contains(b))
            {
                M.writeMultibyte(b);
                return true;
            }
            return false;
        }
    }
}
